# Vertrag (Vertragsakte)

Ein Vertrag wird durch eine Vertragsakte dargestellt, die alle Informationen sowie die <a
href="#!/guide/p10C4B882_3072_4CC4_BED1_E497E57E8B95">Stammdaten</a> zu einem Vertrag enthält. Dabei können alle anfallenden <a
href="#!/guide/p02BB6BA8_742E_4B4C_8D61_C4B723CB9CE5">Vertragsinhalte</a>, wie bspw. E-Mails, Vertragsdokumente oder Kündigungen, ebenfalls zu einem Vertrag hinterlegt werden.

<span class="tag_important">Der Vertrag enthält dabei alle für die Prozesssteuerung und Auffindbarkeit benötigten Metadaten. Sollen mehrere Verträge zusammengeführt werden (Sammelakte), kann hierfür eine <a
href="#!/guide/p3639BF77_213A_477F_B14C_B1568C3E11E7">Vertragssammlung</a> erzeugt werden.</span>

Der aktuelle Zustand des <a
href="#!/guide/p14D09AE6_4738_4539_9DDF_D79C9385A02A">Lebenszyklus</a> eines Vertrags wird über einen <a
href="#!/guide/p6A9FD817_883A_4DBE_ACE2_F7C172FD8BE8">Status</a> abgebildet. Unterschieden wird beim <a
href="#!/guide/pCA53FF2C_9DC7_4920_943C_B62ED0AEBB2B">Vertragsverhältnis</a> zwischen eingehenden und ausgehenden Verträgen. Dies ist für das Vertragscontrolling u.a. für Risikobewertungen von essentieller Bedeutung.

Verträge werden in eine <a
href="#!/guide/p551C5305_D9E1_41D7_9927_32EECF2E617B">Ablagestruktur</a> überführt. Somit ist sichergestellt, dass diese jederzeit auffindbar sind. 

{@img img1.png}

Grundlage für einen Vertrag ist immer ein <a
href="#!/guide/p7B9917EA_3551_445E_A621_AF59E23AE8DF">Vertragstyp</a>. Dieser regelt zum Beispiel, wie die Vertragsnummer erzeugt wird oder welche Metadaten vorbelegt werden.

Bezeichnung eines Vertrags (Kurzbezeichnung)

Unterschieden werden muss zwischen der Vertragsnummer, dem Name des Vertrags und der Vertragsbezeichnung. Diese beschreibt die Kurzbezeichnung des Elements in ELO. Sie wird u.a. in Listendarstellungen verwendet und dient der Identifikation des Objekts.

> <span
style='font-style:italic'>Navigiert der Benutzer bspw. durch den Archivbaum oder verwendet die ELO Suche, dient die Kurzbezeichnung der Identifikation des Objektes. Ein Beispiel: `C00016 Zeitschriftenabo CHIP`. Mithilfe unterschiedlicher Bezeichnungsgeneratoren können Standards bspw. für Personalakten (Aktenzeichen zzgl. Vor- und Nachname) implementiert werden.</span>

{@img img3.png}

Der zu verwendende <a
href="#!/guide/p359C8ED4_DE57_4598_A819_30B6DC4526C4">Bezeichnungsgenerator</a> muss im <a
href="#!/guide/p7B9917EA_3551_445E_A621_AF59E23AE8DF">Vertragstyp</a> hinterlegt werden.

Im Standard setzt sich die Bezeichnung eines Vertrags aus der Vertragsnummer sowie dem Vertragsnamen zusammen. 

{@img img5.png}

Falls notwendig, können weitere Informationen des Vertrags, bspw. der Typ, die Firma des Vertragspartners oder der zuständige Mitarbeiter in die Bezeichnung aufgenommen werden. Weitere Informationen zu Nummer und Bezeichnungen finden sich im Kapitel <a
href="#!/guide/p359C8ED4_DE57_4598_A819_30B6DC4526C4">Vertragsnummer und Bezeichnungen</a>.

## Vertragsnummer

Die Nummer des Vertrags beschreibt ein eindeutiges Kennzeichen für den Vertrag. Sie kann dabei wahlweise aus einem bestehenden Dritt-System übernommen oder durch die <span
style='font-weight:bold;font-style:italic'>ELO Business Solution Contract</span> erzeugt werden.

> <span
style='font-style:italic'>Vertragsnummern helfen ebenfalls dabei, die Kommunikation mit externen Parteien zu vereinfachen. Sie können in die Betreffzeile von E-Mails sowie Vertragsdokumente aufgenommen werden.</span>

### Übernahme der Vertragsnummer aus dem führenden System

Beim Anlegen eines neuen Vertrags kann im Formular die Vertragsnummer des führenden Systems eingegeben werden. In diesem Fall wird keine Vertragsnummer erzeugt. 

{@img img7.png}


<span class="tag_important">In diesem Szenario empfiehlt es sich, eine dynamische Stichwortliste zur Auswahl der Daten aus dem führenden System einzurichten. Somit lassen sich neben der Vertragsnummer auch weitere Daten wie bspw. Mandant, Name des Vertrags, etc. automatisch übernehmen.</span>

Sollen Vertragsnummern nicht manuell vergeben werden dürfen, muss das zugehörige Feld im Formular auf Schreibgeschützt gesetzt werden.

### Erzeugen einer Vertragsnummer durch ELO

Mithilfe eines <a
href="#!/guide/p359C8ED4_DE57_4598_A819_30B6DC4526C4">Vertragsnummern-Generators</a> kann für jeden Vertrag eine eindeutige Kennung erzeugt werden. Dieser Mechanismus greift automatisch, falls beim <a
href="#!/guide/p54A6AC69_E610_48D0_B2E5_CE4E57CE809A">Anlegen des Vertrags</a> keine Vertragsnummer eingegeben oder aus dem führenden System übernommen wird.

Im Standard wird eine Vertragsnummer mit einem Prefix [C] sowie einer laufenden Nummer mit mindestens 6 Stellen erzeugt. 

{@img img9.png}

<span class="tag_warning"><span
style='font-weight:bold'>Erfahrungen aus vergangenen Projekten</span> haben gezeigt, dass sich der Aufbau von Vertragsnummern nach einem bestimmten Schema als hilfreich erweisen kann. Die Nummer C001456 entspricht dem Schema [C]+[Laufende Zahl mit 6 Stellen]. Korrespondenz, bspw. via E-Mail, kann somit automatisch dem zugehörigen Vertrag zugewiesen werden, da die Nummer über einen regulären Ausdruck identifizierbar ist.</span>

<span class="tag_important">Bei der Definition von Nummernkreisen sollte auf die Einheitlichkeit der Nummer im gesamten Unternehmen geachtet werden. </span>

Weitere Informationen zu Nummer und Bezeichnungen finden sich im Kapitel <a
href="#!/guide/p359C8ED4_DE57_4598_A819_30B6DC4526C4">Vertragsnummer und Bezeichnungen</a>.

## Aktualisieren von Ablagepfaden und Bezeichnungen

Werden im Formular (Bspw. beim Einchecken oder Speichern) Indexinformationen geändert wird der Vertrag zum Update registriert. Hierzu übernimmt das Paket common_monitoring die Überwachung geänderter Objekte.

Wurden Indexinformationen geändert wird der Workflow <span
style='font-weight:bold;font-style:italic'>sol.contract.contract.update</span> gestartet. Dieser korrigiert die Kurzbezeichnung, verschiebt (falls notwendig) den Vertrag an eine neue Archivposition und setzt die korrekten Berechtigungen nach geänderter Information im Formular.

{@img img11.png}










